package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (byte, short) -> int}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ByteShortToIntE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param b argument 1
     * @param sh argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    int call(byte b, short sh) throws E;

    /**
     * Binds {@code (b)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> int}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param b argument 1
     * @return a new function {@code (short sh) -> int} that calls
     *      {@code f.call(b, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToIntE<E>
    bind(ByteShortToIntE<E> f, byte b) {
        return (sh) -> f.call(b, sh);
    }

    /**
     * Binds {@code (b)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> int}.
     *
     * @param b argument 1
     * @return a new function {@code (short sh) -> int} that calls
     *      {@code this.call(b, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToIntE<E> bind(byte b) {
        return ByteShortToIntE.bind(this, b);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (byte) -> int}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (byte b) -> int} that calls
     *      {@code f.call(b, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ByteToIntE<E>
    rbind(ByteShortToIntE<E> f, short sh) {
        return (b) -> f.call(b, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (byte) -> int}.
     *
     * @param sh argument 2
     * @return a new function {@code (byte b) -> int} that calls
     *      {@code this.call(b, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ByteToIntE<E> rbind(short sh) {
        return ByteShortToIntE.rbind(this, sh);
    }

    /**
     * Binds {@code (b, sh)} to {@code f}, returning a new function
     * of type {@code () -> int}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param b argument 1
     * @param sh argument 2
     * @return a new function {@code () -> int} that calls
     *      {@code f.call(b, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToIntE<E>
    bind(ByteShortToIntE<E> f, byte b, short sh) {
        return () -> f.call(b, sh);
    }

    /**
     * Binds {@code (b, sh)} to {@code this}, returning a new function
     * of type {@code () -> int}.
     *
     * @param b argument 1
     * @param sh argument 2
     * @return a new function {@code () -> int} that calls
     *      {@code this.call(b, sh)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToIntE<E> bind(byte b, short sh) {
        return ByteShortToIntE.bind(this, b, sh);
    }
}
