package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (byte, short) -> long}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ByteShortToLongE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param b argument 1
     * @param sh argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    long call(byte b, short sh) throws E;

    /**
     * Binds {@code (b)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> long}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param b argument 1
     * @return a new function {@code (short sh) -> long} that calls
     *      {@code f.call(b, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToLongE<E>
    bind(ByteShortToLongE<E> f, byte b) {
        return (sh) -> f.call(b, sh);
    }

    /**
     * Binds {@code (b)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> long}.
     *
     * @param b argument 1
     * @return a new function {@code (short sh) -> long} that calls
     *      {@code this.call(b, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToLongE<E> bind(byte b) {
        return ByteShortToLongE.bind(this, b);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (byte) -> long}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (byte b) -> long} that calls
     *      {@code f.call(b, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ByteToLongE<E>
    rbind(ByteShortToLongE<E> f, short sh) {
        return (b) -> f.call(b, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (byte) -> long}.
     *
     * @param sh argument 2
     * @return a new function {@code (byte b) -> long} that calls
     *      {@code this.call(b, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ByteToLongE<E> rbind(short sh) {
        return ByteShortToLongE.rbind(this, sh);
    }

    /**
     * Binds {@code (b, sh)} to {@code f}, returning a new function
     * of type {@code () -> long}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param b argument 1
     * @param sh argument 2
     * @return a new function {@code () -> long} that calls
     *      {@code f.call(b, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToLongE<E>
    bind(ByteShortToLongE<E> f, byte b, short sh) {
        return () -> f.call(b, sh);
    }

    /**
     * Binds {@code (b, sh)} to {@code this}, returning a new function
     * of type {@code () -> long}.
     *
     * @param b argument 1
     * @param sh argument 2
     * @return a new function {@code () -> long} that calls
     *      {@code this.call(b, sh)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToLongE<E> bind(byte b, short sh) {
        return ByteShortToLongE.bind(this, b, sh);
    }
}
