package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (byte, short) -> void}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ByteShortToNilE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param b argument 1
     * @param sh argument 2
     * @throws E if the operation cannot be completed
     */
    void call(byte b, short sh) throws E;

    /**
     * Binds {@code (b)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> void}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param b argument 1
     * @return a new function {@code (short sh) -> void} that calls
     *      {@code f.call(b, sh)}.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToNilE<E>
    bind(ByteShortToNilE<E> f, byte b) {
        return (sh) -> f.call(b, sh);
    }

    /**
     * Binds {@code (b)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> void}.
     *
     * @param b argument 1
     * @return a new function {@code (short sh) -> void} that calls
     *      {@code this.call(b, sh)}.
     */
    default net.mintern.functions.unary.checked.ShortToNilE<E> bind(byte b) {
        return ByteShortToNilE.bind(this, b);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (byte) -> void}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (byte b) -> void} that calls
     *      {@code f.call(b, sh)}.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ByteToNilE<E>
    rbind(ByteShortToNilE<E> f, short sh) {
        return (b) -> f.call(b, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (byte) -> void}.
     *
     * @param sh argument 2
     * @return a new function {@code (byte b) -> void} that calls
     *      {@code this.call(b, sh)}.
     */
    default net.mintern.functions.unary.checked.ByteToNilE<E> rbind(short sh) {
        return ByteShortToNilE.rbind(this, sh);
    }

    /**
     * Binds {@code (b, sh)} to {@code f}, returning a new function
     * of type {@code () -> void}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param b argument 1
     * @param sh argument 2
     * @return a new function {@code () -> void} that calls
     *      {@code f.call(b, sh)}.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToNilE<E>
    bind(ByteShortToNilE<E> f, byte b, short sh) {
        return () -> f.call(b, sh);
    }

    /**
     * Binds {@code (b, sh)} to {@code this}, returning a new function
     * of type {@code () -> void}.
     *
     * @param b argument 1
     * @param sh argument 2
     * @return a new function {@code () -> void} that calls
     *      {@code this.call(b, sh)}.
     */
    default net.mintern.functions.nullary.checked.NilToNilE<E> bind(byte b, short sh) {
        return ByteShortToNilE.bind(this, b, sh);
    }
}
