package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (char, byte) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface CharByteToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param ch argument 1
     * @param b argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(char ch, byte b) throws E;

    /**
     * Binds {@code (ch)} to the beginning of {@code f}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param ch argument 1
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code f.call(ch, b)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ByteToShortE<E>
    bind(CharByteToShortE<E> f, char ch) {
        return (b) -> f.call(ch, b);
    }

    /**
     * Binds {@code (ch)} to the beginning of {@code this}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param ch argument 1
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code this.call(ch, b)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ByteToShortE<E> bind(char ch) {
        return CharByteToShortE.bind(this, ch);
    }

    /**
     * Binds {@code (b)} to the end of {@code f}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param b argument 2
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code f.call(ch, b)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.CharToShortE<E>
    rbind(CharByteToShortE<E> f, byte b) {
        return (ch) -> f.call(ch, b);
    }

    /**
     * Binds {@code (b)} to the end of {@code this}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param b argument 2
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code this.call(ch, b)} and returns the result.
     */
    default net.mintern.functions.unary.checked.CharToShortE<E> rbind(byte b) {
        return CharByteToShortE.rbind(this, b);
    }

    /**
     * Binds {@code (ch, b)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param ch argument 1
     * @param b argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(ch, b)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(CharByteToShortE<E> f, char ch, byte b) {
        return () -> f.call(ch, b);
    }

    /**
     * Binds {@code (ch, b)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param ch argument 1
     * @param b argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(ch, b)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(char ch, byte b) {
        return CharByteToShortE.bind(this, ch, b);
    }
}
