package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (char, char) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface CharCharToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param ch1 argument 1
     * @param ch2 argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(char ch1, char ch2) throws E;

    /**
     * Binds {@code (ch1)} to the beginning of {@code f}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param ch1 argument 1
     * @return a new function {@code (char ch2) -> short} that calls
     *      {@code f.call(ch1, ch2)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.CharToShortE<E>
    bind(CharCharToShortE<E> f, char ch1) {
        return (ch2) -> f.call(ch1, ch2);
    }

    /**
     * Binds {@code (ch1)} to the beginning of {@code this}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param ch1 argument 1
     * @return a new function {@code (char ch2) -> short} that calls
     *      {@code this.call(ch1, ch2)} and returns the result.
     */
    default net.mintern.functions.unary.checked.CharToShortE<E> bind(char ch1) {
        return CharCharToShortE.bind(this, ch1);
    }

    /**
     * Binds {@code (ch2)} to the end of {@code f}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param ch2 argument 2
     * @return a new function {@code (char ch1) -> short} that calls
     *      {@code f.call(ch1, ch2)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.CharToShortE<E>
    rbind(CharCharToShortE<E> f, char ch2) {
        return (ch1) -> f.call(ch1, ch2);
    }

    /**
     * Binds {@code (ch2)} to the end of {@code this}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param ch2 argument 2
     * @return a new function {@code (char ch1) -> short} that calls
     *      {@code this.call(ch1, ch2)} and returns the result.
     */
    default net.mintern.functions.unary.checked.CharToShortE<E> rbind(char ch2) {
        return CharCharToShortE.rbind(this, ch2);
    }

    /**
     * Binds {@code (ch1, ch2)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param ch1 argument 1
     * @param ch2 argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(ch1, ch2)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(CharCharToShortE<E> f, char ch1, char ch2) {
        return () -> f.call(ch1, ch2);
    }

    /**
     * Binds {@code (ch1, ch2)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param ch1 argument 1
     * @param ch2 argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(ch1, ch2)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(char ch1, char ch2) {
        return CharCharToShortE.bind(this, ch1, ch2);
    }
}
