package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (char, float) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface CharFloatToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param ch argument 1
     * @param fl argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(char ch, float fl) throws E;

    /**
     * Binds {@code (ch)} to the beginning of {@code f}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param ch argument 1
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code f.call(ch, fl)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.FloatToShortE<E>
    bind(CharFloatToShortE<E> f, char ch) {
        return (fl) -> f.call(ch, fl);
    }

    /**
     * Binds {@code (ch)} to the beginning of {@code this}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param ch argument 1
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code this.call(ch, fl)} and returns the result.
     */
    default net.mintern.functions.unary.checked.FloatToShortE<E> bind(char ch) {
        return CharFloatToShortE.bind(this, ch);
    }

    /**
     * Binds {@code (fl)} to the end of {@code f}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param fl argument 2
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code f.call(ch, fl)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.CharToShortE<E>
    rbind(CharFloatToShortE<E> f, float fl) {
        return (ch) -> f.call(ch, fl);
    }

    /**
     * Binds {@code (fl)} to the end of {@code this}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param fl argument 2
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code this.call(ch, fl)} and returns the result.
     */
    default net.mintern.functions.unary.checked.CharToShortE<E> rbind(float fl) {
        return CharFloatToShortE.rbind(this, fl);
    }

    /**
     * Binds {@code (ch, fl)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param ch argument 1
     * @param fl argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(ch, fl)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(CharFloatToShortE<E> f, char ch, float fl) {
        return () -> f.call(ch, fl);
    }

    /**
     * Binds {@code (ch, fl)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param ch argument 1
     * @param fl argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(ch, fl)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(char ch, float fl) {
        return CharFloatToShortE.bind(this, ch, fl);
    }
}
