package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (char, long) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface CharLongToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param ch argument 1
     * @param l argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(char ch, long l) throws E;

    /**
     * Binds {@code (ch)} to the beginning of {@code f}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param ch argument 1
     * @return a new function {@code (long l) -> short} that calls
     *      {@code f.call(ch, l)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.LongToShortE<E>
    bind(CharLongToShortE<E> f, char ch) {
        return (l) -> f.call(ch, l);
    }

    /**
     * Binds {@code (ch)} to the beginning of {@code this}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param ch argument 1
     * @return a new function {@code (long l) -> short} that calls
     *      {@code this.call(ch, l)} and returns the result.
     */
    default net.mintern.functions.unary.checked.LongToShortE<E> bind(char ch) {
        return CharLongToShortE.bind(this, ch);
    }

    /**
     * Binds {@code (l)} to the end of {@code f}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l argument 2
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code f.call(ch, l)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.CharToShortE<E>
    rbind(CharLongToShortE<E> f, long l) {
        return (ch) -> f.call(ch, l);
    }

    /**
     * Binds {@code (l)} to the end of {@code this}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param l argument 2
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code this.call(ch, l)} and returns the result.
     */
    default net.mintern.functions.unary.checked.CharToShortE<E> rbind(long l) {
        return CharLongToShortE.rbind(this, l);
    }

    /**
     * Binds {@code (ch, l)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param ch argument 1
     * @param l argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(ch, l)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(CharLongToShortE<E> f, char ch, long l) {
        return () -> f.call(ch, l);
    }

    /**
     * Binds {@code (ch, l)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param ch argument 1
     * @param l argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(ch, l)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(char ch, long l) {
        return CharLongToShortE.bind(this, ch, l);
    }
}
