package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (char, short) -> int}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface CharShortToIntE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param ch argument 1
     * @param sh argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    int call(char ch, short sh) throws E;

    /**
     * Binds {@code (ch)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> int}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param ch argument 1
     * @return a new function {@code (short sh) -> int} that calls
     *      {@code f.call(ch, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToIntE<E>
    bind(CharShortToIntE<E> f, char ch) {
        return (sh) -> f.call(ch, sh);
    }

    /**
     * Binds {@code (ch)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> int}.
     *
     * @param ch argument 1
     * @return a new function {@code (short sh) -> int} that calls
     *      {@code this.call(ch, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToIntE<E> bind(char ch) {
        return CharShortToIntE.bind(this, ch);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (char) -> int}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (char ch) -> int} that calls
     *      {@code f.call(ch, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.CharToIntE<E>
    rbind(CharShortToIntE<E> f, short sh) {
        return (ch) -> f.call(ch, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (char) -> int}.
     *
     * @param sh argument 2
     * @return a new function {@code (char ch) -> int} that calls
     *      {@code this.call(ch, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.CharToIntE<E> rbind(short sh) {
        return CharShortToIntE.rbind(this, sh);
    }

    /**
     * Binds {@code (ch, sh)} to {@code f}, returning a new function
     * of type {@code () -> int}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param ch argument 1
     * @param sh argument 2
     * @return a new function {@code () -> int} that calls
     *      {@code f.call(ch, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToIntE<E>
    bind(CharShortToIntE<E> f, char ch, short sh) {
        return () -> f.call(ch, sh);
    }

    /**
     * Binds {@code (ch, sh)} to {@code this}, returning a new function
     * of type {@code () -> int}.
     *
     * @param ch argument 1
     * @param sh argument 2
     * @return a new function {@code () -> int} that calls
     *      {@code this.call(ch, sh)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToIntE<E> bind(char ch, short sh) {
        return CharShortToIntE.bind(this, ch, sh);
    }
}
