package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (double, double) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface DblDblToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param d1 argument 1
     * @param d2 argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(double d1, double d2) throws E;

    /**
     * Binds {@code (d1)} to the beginning of {@code f}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param d1 argument 1
     * @return a new function {@code (double d2) -> short} that calls
     *      {@code f.call(d1, d2)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.DblToShortE<E>
    bind(DblDblToShortE<E> f, double d1) {
        return (d2) -> f.call(d1, d2);
    }

    /**
     * Binds {@code (d1)} to the beginning of {@code this}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param d1 argument 1
     * @return a new function {@code (double d2) -> short} that calls
     *      {@code this.call(d1, d2)} and returns the result.
     */
    default net.mintern.functions.unary.checked.DblToShortE<E> bind(double d1) {
        return DblDblToShortE.bind(this, d1);
    }

    /**
     * Binds {@code (d2)} to the end of {@code f}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param d2 argument 2
     * @return a new function {@code (double d1) -> short} that calls
     *      {@code f.call(d1, d2)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.DblToShortE<E>
    rbind(DblDblToShortE<E> f, double d2) {
        return (d1) -> f.call(d1, d2);
    }

    /**
     * Binds {@code (d2)} to the end of {@code this}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param d2 argument 2
     * @return a new function {@code (double d1) -> short} that calls
     *      {@code this.call(d1, d2)} and returns the result.
     */
    default net.mintern.functions.unary.checked.DblToShortE<E> rbind(double d2) {
        return DblDblToShortE.rbind(this, d2);
    }

    /**
     * Binds {@code (d1, d2)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param d1 argument 1
     * @param d2 argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(d1, d2)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(DblDblToShortE<E> f, double d1, double d2) {
        return () -> f.call(d1, d2);
    }

    /**
     * Binds {@code (d1, d2)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param d1 argument 1
     * @param d2 argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(d1, d2)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(double d1, double d2) {
        return DblDblToShortE.bind(this, d1, d2);
    }
}
