package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (double, float) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface DblFloatToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param d argument 1
     * @param fl argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(double d, float fl) throws E;

    /**
     * Binds {@code (d)} to the beginning of {@code f}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param d argument 1
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code f.call(d, fl)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.FloatToShortE<E>
    bind(DblFloatToShortE<E> f, double d) {
        return (fl) -> f.call(d, fl);
    }

    /**
     * Binds {@code (d)} to the beginning of {@code this}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param d argument 1
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code this.call(d, fl)} and returns the result.
     */
    default net.mintern.functions.unary.checked.FloatToShortE<E> bind(double d) {
        return DblFloatToShortE.bind(this, d);
    }

    /**
     * Binds {@code (fl)} to the end of {@code f}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param fl argument 2
     * @return a new function {@code (double d) -> short} that calls
     *      {@code f.call(d, fl)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.DblToShortE<E>
    rbind(DblFloatToShortE<E> f, float fl) {
        return (d) -> f.call(d, fl);
    }

    /**
     * Binds {@code (fl)} to the end of {@code this}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param fl argument 2
     * @return a new function {@code (double d) -> short} that calls
     *      {@code this.call(d, fl)} and returns the result.
     */
    default net.mintern.functions.unary.checked.DblToShortE<E> rbind(float fl) {
        return DblFloatToShortE.rbind(this, fl);
    }

    /**
     * Binds {@code (d, fl)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param d argument 1
     * @param fl argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(d, fl)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(DblFloatToShortE<E> f, double d, float fl) {
        return () -> f.call(d, fl);
    }

    /**
     * Binds {@code (d, fl)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param d argument 1
     * @param fl argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(d, fl)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(double d, float fl) {
        return DblFloatToShortE.bind(this, d, fl);
    }
}
