package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (double, int) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface DblIntToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param d argument 1
     * @param i argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(double d, int i) throws E;

    /**
     * Binds {@code (d)} to the beginning of {@code f}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param d argument 1
     * @return a new function {@code (int i) -> short} that calls
     *      {@code f.call(d, i)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.IntToShortE<E>
    bind(DblIntToShortE<E> f, double d) {
        return (i) -> f.call(d, i);
    }

    /**
     * Binds {@code (d)} to the beginning of {@code this}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param d argument 1
     * @return a new function {@code (int i) -> short} that calls
     *      {@code this.call(d, i)} and returns the result.
     */
    default net.mintern.functions.unary.checked.IntToShortE<E> bind(double d) {
        return DblIntToShortE.bind(this, d);
    }

    /**
     * Binds {@code (i)} to the end of {@code f}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param i argument 2
     * @return a new function {@code (double d) -> short} that calls
     *      {@code f.call(d, i)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.DblToShortE<E>
    rbind(DblIntToShortE<E> f, int i) {
        return (d) -> f.call(d, i);
    }

    /**
     * Binds {@code (i)} to the end of {@code this}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param i argument 2
     * @return a new function {@code (double d) -> short} that calls
     *      {@code this.call(d, i)} and returns the result.
     */
    default net.mintern.functions.unary.checked.DblToShortE<E> rbind(int i) {
        return DblIntToShortE.rbind(this, i);
    }

    /**
     * Binds {@code (d, i)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param d argument 1
     * @param i argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(d, i)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(DblIntToShortE<E> f, double d, int i) {
        return () -> f.call(d, i);
    }

    /**
     * Binds {@code (d, i)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param d argument 1
     * @param i argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(d, i)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(double d, int i) {
        return DblIntToShortE.bind(this, d, i);
    }
}
