package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (double, long) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface DblLongToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param d argument 1
     * @param l argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(double d, long l) throws E;

    /**
     * Binds {@code (d)} to the beginning of {@code f}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param d argument 1
     * @return a new function {@code (long l) -> short} that calls
     *      {@code f.call(d, l)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.LongToShortE<E>
    bind(DblLongToShortE<E> f, double d) {
        return (l) -> f.call(d, l);
    }

    /**
     * Binds {@code (d)} to the beginning of {@code this}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param d argument 1
     * @return a new function {@code (long l) -> short} that calls
     *      {@code this.call(d, l)} and returns the result.
     */
    default net.mintern.functions.unary.checked.LongToShortE<E> bind(double d) {
        return DblLongToShortE.bind(this, d);
    }

    /**
     * Binds {@code (l)} to the end of {@code f}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l argument 2
     * @return a new function {@code (double d) -> short} that calls
     *      {@code f.call(d, l)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.DblToShortE<E>
    rbind(DblLongToShortE<E> f, long l) {
        return (d) -> f.call(d, l);
    }

    /**
     * Binds {@code (l)} to the end of {@code this}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param l argument 2
     * @return a new function {@code (double d) -> short} that calls
     *      {@code this.call(d, l)} and returns the result.
     */
    default net.mintern.functions.unary.checked.DblToShortE<E> rbind(long l) {
        return DblLongToShortE.rbind(this, l);
    }

    /**
     * Binds {@code (d, l)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param d argument 1
     * @param l argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(d, l)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(DblLongToShortE<E> f, double d, long l) {
        return () -> f.call(d, l);
    }

    /**
     * Binds {@code (d, l)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param d argument 1
     * @param l argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(d, l)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(double d, long l) {
        return DblLongToShortE.bind(this, d, l);
    }
}
