package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (double, U) -> short}.
 *
 * @param <U> the type of argument 2
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface DblObjToShortE<U, E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param d argument 1
     * @param u argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(double d, U u) throws E;

    /**
     * Binds {@code (d)} to the beginning of {@code f}, returning a new function
     * of type {@code (U) -> short}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param d argument 1
     * @return a new function {@code (U u) -> short} that calls
     *      {@code f.call(d, u)} and returns the result.
     */
    static <U, E extends Exception> net.mintern.functions.unary.checked.ObjToShortE<U, E>
    bind(DblObjToShortE<U, E> f, double d) {
        return (u) -> f.call(d, u);
    }

    /**
     * Binds {@code (d)} to the beginning of {@code this}, returning a new function
     * of type {@code (U) -> short}.
     *
     * @param d argument 1
     * @return a new function {@code (U u) -> short} that calls
     *      {@code this.call(d, u)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ObjToShortE<U, E> bind(double d) {
        return DblObjToShortE.bind(this, d);
    }

    /**
     * Binds {@code (u)} to the end of {@code f}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param u argument 2
     * @return a new function {@code (double d) -> short} that calls
     *      {@code f.call(d, u)} and returns the result.
     */
    static <U, E extends Exception> net.mintern.functions.unary.checked.DblToShortE<E>
    rbind(DblObjToShortE<U, E> f, U u) {
        return (d) -> f.call(d, u);
    }

    /**
     * Binds {@code (u)} to the end of {@code this}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param u argument 2
     * @return a new function {@code (double d) -> short} that calls
     *      {@code this.call(d, u)} and returns the result.
     */
    default net.mintern.functions.unary.checked.DblToShortE<E> rbind(U u) {
        return DblObjToShortE.rbind(this, u);
    }

    /**
     * Binds {@code (d, u)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param d argument 1
     * @param u argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(d, u)} and returns the result.
     */
    static <U, E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(DblObjToShortE<U, E> f, double d, U u) {
        return () -> f.call(d, u);
    }

    /**
     * Binds {@code (d, u)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param d argument 1
     * @param u argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(d, u)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(double d, U u) {
        return DblObjToShortE.bind(this, d, u);
    }
}
