package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (double, short) -> char}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface DblShortToCharE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param d argument 1
     * @param sh argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    char call(double d, short sh) throws E;

    /**
     * Binds {@code (d)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> char}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param d argument 1
     * @return a new function {@code (short sh) -> char} that calls
     *      {@code f.call(d, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToCharE<E>
    bind(DblShortToCharE<E> f, double d) {
        return (sh) -> f.call(d, sh);
    }

    /**
     * Binds {@code (d)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> char}.
     *
     * @param d argument 1
     * @return a new function {@code (short sh) -> char} that calls
     *      {@code this.call(d, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToCharE<E> bind(double d) {
        return DblShortToCharE.bind(this, d);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (double) -> char}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (double d) -> char} that calls
     *      {@code f.call(d, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.DblToCharE<E>
    rbind(DblShortToCharE<E> f, short sh) {
        return (d) -> f.call(d, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (double) -> char}.
     *
     * @param sh argument 2
     * @return a new function {@code (double d) -> char} that calls
     *      {@code this.call(d, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.DblToCharE<E> rbind(short sh) {
        return DblShortToCharE.rbind(this, sh);
    }

    /**
     * Binds {@code (d, sh)} to {@code f}, returning a new function
     * of type {@code () -> char}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param d argument 1
     * @param sh argument 2
     * @return a new function {@code () -> char} that calls
     *      {@code f.call(d, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToCharE<E>
    bind(DblShortToCharE<E> f, double d, short sh) {
        return () -> f.call(d, sh);
    }

    /**
     * Binds {@code (d, sh)} to {@code this}, returning a new function
     * of type {@code () -> char}.
     *
     * @param d argument 1
     * @param sh argument 2
     * @return a new function {@code () -> char} that calls
     *      {@code this.call(d, sh)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToCharE<E> bind(double d, short sh) {
        return DblShortToCharE.bind(this, d, sh);
    }
}
