package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (double, short) -> long}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface DblShortToLongE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param d argument 1
     * @param sh argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    long call(double d, short sh) throws E;

    /**
     * Binds {@code (d)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> long}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param d argument 1
     * @return a new function {@code (short sh) -> long} that calls
     *      {@code f.call(d, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToLongE<E>
    bind(DblShortToLongE<E> f, double d) {
        return (sh) -> f.call(d, sh);
    }

    /**
     * Binds {@code (d)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> long}.
     *
     * @param d argument 1
     * @return a new function {@code (short sh) -> long} that calls
     *      {@code this.call(d, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToLongE<E> bind(double d) {
        return DblShortToLongE.bind(this, d);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (double) -> long}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (double d) -> long} that calls
     *      {@code f.call(d, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.DblToLongE<E>
    rbind(DblShortToLongE<E> f, short sh) {
        return (d) -> f.call(d, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (double) -> long}.
     *
     * @param sh argument 2
     * @return a new function {@code (double d) -> long} that calls
     *      {@code this.call(d, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.DblToLongE<E> rbind(short sh) {
        return DblShortToLongE.rbind(this, sh);
    }

    /**
     * Binds {@code (d, sh)} to {@code f}, returning a new function
     * of type {@code () -> long}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param d argument 1
     * @param sh argument 2
     * @return a new function {@code () -> long} that calls
     *      {@code f.call(d, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToLongE<E>
    bind(DblShortToLongE<E> f, double d, short sh) {
        return () -> f.call(d, sh);
    }

    /**
     * Binds {@code (d, sh)} to {@code this}, returning a new function
     * of type {@code () -> long}.
     *
     * @param d argument 1
     * @param sh argument 2
     * @return a new function {@code () -> long} that calls
     *      {@code this.call(d, sh)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToLongE<E> bind(double d, short sh) {
        return DblShortToLongE.bind(this, d, sh);
    }
}
