package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (double, short) -> R}.
 *
 * @param <R> the type of the return value
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface DblShortToObjE<R, E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param d argument 1
     * @param sh argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    R call(double d, short sh) throws E;

    /**
     * Binds {@code (d)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param d argument 1
     * @return a new function {@code (short sh) -> R} that calls
     *      {@code f.call(d, sh)} and returns the result.
     */
    static <R, E extends Exception> net.mintern.functions.unary.checked.ShortToObjE<R, E>
    bind(DblShortToObjE<R, E> f, double d) {
        return (sh) -> f.call(d, sh);
    }

    /**
     * Binds {@code (d)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param d argument 1
     * @return a new function {@code (short sh) -> R} that calls
     *      {@code this.call(d, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToObjE<R, E> bind(double d) {
        return DblShortToObjE.bind(this, d);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (double) -> R}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (double d) -> R} that calls
     *      {@code f.call(d, sh)} and returns the result.
     */
    static <R, E extends Exception> net.mintern.functions.unary.checked.DblToObjE<R, E>
    rbind(DblShortToObjE<R, E> f, short sh) {
        return (d) -> f.call(d, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (double) -> R}.
     *
     * @param sh argument 2
     * @return a new function {@code (double d) -> R} that calls
     *      {@code this.call(d, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.DblToObjE<R, E> rbind(short sh) {
        return DblShortToObjE.rbind(this, sh);
    }

    /**
     * Binds {@code (d, sh)} to {@code f}, returning a new function
     * of type {@code () -> R}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param d argument 1
     * @param sh argument 2
     * @return a new function {@code () -> R} that calls
     *      {@code f.call(d, sh)} and returns the result.
     */
    @SuppressWarnings("unchecked") // maven spuriously warns about a type error in this case
    static <R, E extends Exception> net.mintern.functions.nullary.checked.NilToObjE<R, E>
    bind(DblShortToObjE<R, E> f, double d, short sh) {
        return () -> f.call(d, sh);
    }

    /**
     * Binds {@code (d, sh)} to {@code this}, returning a new function
     * of type {@code () -> R}.
     *
     * @param d argument 1
     * @param sh argument 2
     * @return a new function {@code () -> R} that calls
     *      {@code this.call(d, sh)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToObjE<R, E> bind(double d, short sh) {
        return DblShortToObjE.bind(this, d, sh);
    }
}
