package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (float, char) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface FloatCharToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param fl argument 1
     * @param ch argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(float fl, char ch) throws E;

    /**
     * Binds {@code (fl)} to the beginning of {@code f}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param fl argument 1
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code f.call(fl, ch)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.CharToShortE<E>
    bind(FloatCharToShortE<E> f, float fl) {
        return (ch) -> f.call(fl, ch);
    }

    /**
     * Binds {@code (fl)} to the beginning of {@code this}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param fl argument 1
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code this.call(fl, ch)} and returns the result.
     */
    default net.mintern.functions.unary.checked.CharToShortE<E> bind(float fl) {
        return FloatCharToShortE.bind(this, fl);
    }

    /**
     * Binds {@code (ch)} to the end of {@code f}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param ch argument 2
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code f.call(fl, ch)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.FloatToShortE<E>
    rbind(FloatCharToShortE<E> f, char ch) {
        return (fl) -> f.call(fl, ch);
    }

    /**
     * Binds {@code (ch)} to the end of {@code this}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param ch argument 2
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code this.call(fl, ch)} and returns the result.
     */
    default net.mintern.functions.unary.checked.FloatToShortE<E> rbind(char ch) {
        return FloatCharToShortE.rbind(this, ch);
    }

    /**
     * Binds {@code (fl, ch)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param fl argument 1
     * @param ch argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(fl, ch)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(FloatCharToShortE<E> f, float fl, char ch) {
        return () -> f.call(fl, ch);
    }

    /**
     * Binds {@code (fl, ch)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param fl argument 1
     * @param ch argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(fl, ch)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(float fl, char ch) {
        return FloatCharToShortE.bind(this, fl, ch);
    }
}
