package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (float, double) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface FloatDblToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param fl argument 1
     * @param d argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(float fl, double d) throws E;

    /**
     * Binds {@code (fl)} to the beginning of {@code f}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param fl argument 1
     * @return a new function {@code (double d) -> short} that calls
     *      {@code f.call(fl, d)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.DblToShortE<E>
    bind(FloatDblToShortE<E> f, float fl) {
        return (d) -> f.call(fl, d);
    }

    /**
     * Binds {@code (fl)} to the beginning of {@code this}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param fl argument 1
     * @return a new function {@code (double d) -> short} that calls
     *      {@code this.call(fl, d)} and returns the result.
     */
    default net.mintern.functions.unary.checked.DblToShortE<E> bind(float fl) {
        return FloatDblToShortE.bind(this, fl);
    }

    /**
     * Binds {@code (d)} to the end of {@code f}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param d argument 2
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code f.call(fl, d)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.FloatToShortE<E>
    rbind(FloatDblToShortE<E> f, double d) {
        return (fl) -> f.call(fl, d);
    }

    /**
     * Binds {@code (d)} to the end of {@code this}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param d argument 2
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code this.call(fl, d)} and returns the result.
     */
    default net.mintern.functions.unary.checked.FloatToShortE<E> rbind(double d) {
        return FloatDblToShortE.rbind(this, d);
    }

    /**
     * Binds {@code (fl, d)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param fl argument 1
     * @param d argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(fl, d)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(FloatDblToShortE<E> f, float fl, double d) {
        return () -> f.call(fl, d);
    }

    /**
     * Binds {@code (fl, d)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param fl argument 1
     * @param d argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(fl, d)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(float fl, double d) {
        return FloatDblToShortE.bind(this, fl, d);
    }
}
