package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (float, long) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface FloatLongToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param fl argument 1
     * @param l argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(float fl, long l) throws E;

    /**
     * Binds {@code (fl)} to the beginning of {@code f}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param fl argument 1
     * @return a new function {@code (long l) -> short} that calls
     *      {@code f.call(fl, l)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.LongToShortE<E>
    bind(FloatLongToShortE<E> f, float fl) {
        return (l) -> f.call(fl, l);
    }

    /**
     * Binds {@code (fl)} to the beginning of {@code this}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param fl argument 1
     * @return a new function {@code (long l) -> short} that calls
     *      {@code this.call(fl, l)} and returns the result.
     */
    default net.mintern.functions.unary.checked.LongToShortE<E> bind(float fl) {
        return FloatLongToShortE.bind(this, fl);
    }

    /**
     * Binds {@code (l)} to the end of {@code f}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l argument 2
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code f.call(fl, l)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.FloatToShortE<E>
    rbind(FloatLongToShortE<E> f, long l) {
        return (fl) -> f.call(fl, l);
    }

    /**
     * Binds {@code (l)} to the end of {@code this}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param l argument 2
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code this.call(fl, l)} and returns the result.
     */
    default net.mintern.functions.unary.checked.FloatToShortE<E> rbind(long l) {
        return FloatLongToShortE.rbind(this, l);
    }

    /**
     * Binds {@code (fl, l)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param fl argument 1
     * @param l argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(fl, l)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(FloatLongToShortE<E> f, float fl, long l) {
        return () -> f.call(fl, l);
    }

    /**
     * Binds {@code (fl, l)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param fl argument 1
     * @param l argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(fl, l)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(float fl, long l) {
        return FloatLongToShortE.bind(this, fl, l);
    }
}
