package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (float, short) -> boolean}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface FloatShortToBoolE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param fl argument 1
     * @param sh argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    boolean call(float fl, short sh) throws E;

    /**
     * Binds {@code (fl)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> boolean}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param fl argument 1
     * @return a new function {@code (short sh) -> boolean} that calls
     *      {@code f.call(fl, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToBoolE<E>
    bind(FloatShortToBoolE<E> f, float fl) {
        return (sh) -> f.call(fl, sh);
    }

    /**
     * Binds {@code (fl)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> boolean}.
     *
     * @param fl argument 1
     * @return a new function {@code (short sh) -> boolean} that calls
     *      {@code this.call(fl, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToBoolE<E> bind(float fl) {
        return FloatShortToBoolE.bind(this, fl);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (float) -> boolean}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (float fl) -> boolean} that calls
     *      {@code f.call(fl, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.FloatToBoolE<E>
    rbind(FloatShortToBoolE<E> f, short sh) {
        return (fl) -> f.call(fl, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (float) -> boolean}.
     *
     * @param sh argument 2
     * @return a new function {@code (float fl) -> boolean} that calls
     *      {@code this.call(fl, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.FloatToBoolE<E> rbind(short sh) {
        return FloatShortToBoolE.rbind(this, sh);
    }

    /**
     * Binds {@code (fl, sh)} to {@code f}, returning a new function
     * of type {@code () -> boolean}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param fl argument 1
     * @param sh argument 2
     * @return a new function {@code () -> boolean} that calls
     *      {@code f.call(fl, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToBoolE<E>
    bind(FloatShortToBoolE<E> f, float fl, short sh) {
        return () -> f.call(fl, sh);
    }

    /**
     * Binds {@code (fl, sh)} to {@code this}, returning a new function
     * of type {@code () -> boolean}.
     *
     * @param fl argument 1
     * @param sh argument 2
     * @return a new function {@code () -> boolean} that calls
     *      {@code this.call(fl, sh)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToBoolE<E> bind(float fl, short sh) {
        return FloatShortToBoolE.bind(this, fl, sh);
    }
}
