package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (float, short) -> float}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface FloatShortToFloatE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param fl argument 1
     * @param sh argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    float call(float fl, short sh) throws E;

    /**
     * Binds {@code (fl)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> float}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param fl argument 1
     * @return a new function {@code (short sh) -> float} that calls
     *      {@code f.call(fl, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToFloatE<E>
    bind(FloatShortToFloatE<E> f, float fl) {
        return (sh) -> f.call(fl, sh);
    }

    /**
     * Binds {@code (fl)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> float}.
     *
     * @param fl argument 1
     * @return a new function {@code (short sh) -> float} that calls
     *      {@code this.call(fl, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToFloatE<E> bind(float fl) {
        return FloatShortToFloatE.bind(this, fl);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (float) -> float}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (float fl) -> float} that calls
     *      {@code f.call(fl, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.FloatToFloatE<E>
    rbind(FloatShortToFloatE<E> f, short sh) {
        return (fl) -> f.call(fl, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (float) -> float}.
     *
     * @param sh argument 2
     * @return a new function {@code (float fl) -> float} that calls
     *      {@code this.call(fl, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.FloatToFloatE<E> rbind(short sh) {
        return FloatShortToFloatE.rbind(this, sh);
    }

    /**
     * Binds {@code (fl, sh)} to {@code f}, returning a new function
     * of type {@code () -> float}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param fl argument 1
     * @param sh argument 2
     * @return a new function {@code () -> float} that calls
     *      {@code f.call(fl, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToFloatE<E>
    bind(FloatShortToFloatE<E> f, float fl, short sh) {
        return () -> f.call(fl, sh);
    }

    /**
     * Binds {@code (fl, sh)} to {@code this}, returning a new function
     * of type {@code () -> float}.
     *
     * @param fl argument 1
     * @param sh argument 2
     * @return a new function {@code () -> float} that calls
     *      {@code this.call(fl, sh)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToFloatE<E> bind(float fl, short sh) {
        return FloatShortToFloatE.bind(this, fl, sh);
    }
}
