package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (float, short) -> R}.
 *
 * @param <R> the type of the return value
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface FloatShortToObjE<R, E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param fl argument 1
     * @param sh argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    R call(float fl, short sh) throws E;

    /**
     * Binds {@code (fl)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param fl argument 1
     * @return a new function {@code (short sh) -> R} that calls
     *      {@code f.call(fl, sh)} and returns the result.
     */
    static <R, E extends Exception> net.mintern.functions.unary.checked.ShortToObjE<R, E>
    bind(FloatShortToObjE<R, E> f, float fl) {
        return (sh) -> f.call(fl, sh);
    }

    /**
     * Binds {@code (fl)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param fl argument 1
     * @return a new function {@code (short sh) -> R} that calls
     *      {@code this.call(fl, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToObjE<R, E> bind(float fl) {
        return FloatShortToObjE.bind(this, fl);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (float) -> R}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (float fl) -> R} that calls
     *      {@code f.call(fl, sh)} and returns the result.
     */
    static <R, E extends Exception> net.mintern.functions.unary.checked.FloatToObjE<R, E>
    rbind(FloatShortToObjE<R, E> f, short sh) {
        return (fl) -> f.call(fl, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (float) -> R}.
     *
     * @param sh argument 2
     * @return a new function {@code (float fl) -> R} that calls
     *      {@code this.call(fl, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.FloatToObjE<R, E> rbind(short sh) {
        return FloatShortToObjE.rbind(this, sh);
    }

    /**
     * Binds {@code (fl, sh)} to {@code f}, returning a new function
     * of type {@code () -> R}.
     *
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param fl argument 1
     * @param sh argument 2
     * @return a new function {@code () -> R} that calls
     *      {@code f.call(fl, sh)} and returns the result.
     */
    @SuppressWarnings("unchecked") // maven spuriously warns about a type error in this case
    static <R, E extends Exception> net.mintern.functions.nullary.checked.NilToObjE<R, E>
    bind(FloatShortToObjE<R, E> f, float fl, short sh) {
        return () -> f.call(fl, sh);
    }

    /**
     * Binds {@code (fl, sh)} to {@code this}, returning a new function
     * of type {@code () -> R}.
     *
     * @param fl argument 1
     * @param sh argument 2
     * @return a new function {@code () -> R} that calls
     *      {@code this.call(fl, sh)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToObjE<R, E> bind(float fl, short sh) {
        return FloatShortToObjE.bind(this, fl, sh);
    }
}
