package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (int, byte) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface IntByteToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param i argument 1
     * @param b argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(int i, byte b) throws E;

    /**
     * Binds {@code (i)} to the beginning of {@code f}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param i argument 1
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code f.call(i, b)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ByteToShortE<E>
    bind(IntByteToShortE<E> f, int i) {
        return (b) -> f.call(i, b);
    }

    /**
     * Binds {@code (i)} to the beginning of {@code this}, returning a new function
     * of type {@code (byte) -> short}.
     *
     * @param i argument 1
     * @return a new function {@code (byte b) -> short} that calls
     *      {@code this.call(i, b)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ByteToShortE<E> bind(int i) {
        return IntByteToShortE.bind(this, i);
    }

    /**
     * Binds {@code (b)} to the end of {@code f}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param b argument 2
     * @return a new function {@code (int i) -> short} that calls
     *      {@code f.call(i, b)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.IntToShortE<E>
    rbind(IntByteToShortE<E> f, byte b) {
        return (i) -> f.call(i, b);
    }

    /**
     * Binds {@code (b)} to the end of {@code this}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param b argument 2
     * @return a new function {@code (int i) -> short} that calls
     *      {@code this.call(i, b)} and returns the result.
     */
    default net.mintern.functions.unary.checked.IntToShortE<E> rbind(byte b) {
        return IntByteToShortE.rbind(this, b);
    }

    /**
     * Binds {@code (i, b)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param i argument 1
     * @param b argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(i, b)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(IntByteToShortE<E> f, int i, byte b) {
        return () -> f.call(i, b);
    }

    /**
     * Binds {@code (i, b)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param i argument 1
     * @param b argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(i, b)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(int i, byte b) {
        return IntByteToShortE.bind(this, i, b);
    }
}
