package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (int, char) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface IntCharToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param i argument 1
     * @param ch argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(int i, char ch) throws E;

    /**
     * Binds {@code (i)} to the beginning of {@code f}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param i argument 1
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code f.call(i, ch)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.CharToShortE<E>
    bind(IntCharToShortE<E> f, int i) {
        return (ch) -> f.call(i, ch);
    }

    /**
     * Binds {@code (i)} to the beginning of {@code this}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param i argument 1
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code this.call(i, ch)} and returns the result.
     */
    default net.mintern.functions.unary.checked.CharToShortE<E> bind(int i) {
        return IntCharToShortE.bind(this, i);
    }

    /**
     * Binds {@code (ch)} to the end of {@code f}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param ch argument 2
     * @return a new function {@code (int i) -> short} that calls
     *      {@code f.call(i, ch)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.IntToShortE<E>
    rbind(IntCharToShortE<E> f, char ch) {
        return (i) -> f.call(i, ch);
    }

    /**
     * Binds {@code (ch)} to the end of {@code this}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param ch argument 2
     * @return a new function {@code (int i) -> short} that calls
     *      {@code this.call(i, ch)} and returns the result.
     */
    default net.mintern.functions.unary.checked.IntToShortE<E> rbind(char ch) {
        return IntCharToShortE.rbind(this, ch);
    }

    /**
     * Binds {@code (i, ch)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param i argument 1
     * @param ch argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(i, ch)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(IntCharToShortE<E> f, int i, char ch) {
        return () -> f.call(i, ch);
    }

    /**
     * Binds {@code (i, ch)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param i argument 1
     * @param ch argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(i, ch)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(int i, char ch) {
        return IntCharToShortE.bind(this, i, ch);
    }
}
