package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (int, double) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface IntDblToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param i argument 1
     * @param d argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(int i, double d) throws E;

    /**
     * Binds {@code (i)} to the beginning of {@code f}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param i argument 1
     * @return a new function {@code (double d) -> short} that calls
     *      {@code f.call(i, d)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.DblToShortE<E>
    bind(IntDblToShortE<E> f, int i) {
        return (d) -> f.call(i, d);
    }

    /**
     * Binds {@code (i)} to the beginning of {@code this}, returning a new function
     * of type {@code (double) -> short}.
     *
     * @param i argument 1
     * @return a new function {@code (double d) -> short} that calls
     *      {@code this.call(i, d)} and returns the result.
     */
    default net.mintern.functions.unary.checked.DblToShortE<E> bind(int i) {
        return IntDblToShortE.bind(this, i);
    }

    /**
     * Binds {@code (d)} to the end of {@code f}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param d argument 2
     * @return a new function {@code (int i) -> short} that calls
     *      {@code f.call(i, d)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.IntToShortE<E>
    rbind(IntDblToShortE<E> f, double d) {
        return (i) -> f.call(i, d);
    }

    /**
     * Binds {@code (d)} to the end of {@code this}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param d argument 2
     * @return a new function {@code (int i) -> short} that calls
     *      {@code this.call(i, d)} and returns the result.
     */
    default net.mintern.functions.unary.checked.IntToShortE<E> rbind(double d) {
        return IntDblToShortE.rbind(this, d);
    }

    /**
     * Binds {@code (i, d)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param i argument 1
     * @param d argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(i, d)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(IntDblToShortE<E> f, int i, double d) {
        return () -> f.call(i, d);
    }

    /**
     * Binds {@code (i, d)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param i argument 1
     * @param d argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(i, d)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(int i, double d) {
        return IntDblToShortE.bind(this, i, d);
    }
}
