package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (int, float) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface IntFloatToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param i argument 1
     * @param fl argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(int i, float fl) throws E;

    /**
     * Binds {@code (i)} to the beginning of {@code f}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param i argument 1
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code f.call(i, fl)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.FloatToShortE<E>
    bind(IntFloatToShortE<E> f, int i) {
        return (fl) -> f.call(i, fl);
    }

    /**
     * Binds {@code (i)} to the beginning of {@code this}, returning a new function
     * of type {@code (float) -> short}.
     *
     * @param i argument 1
     * @return a new function {@code (float fl) -> short} that calls
     *      {@code this.call(i, fl)} and returns the result.
     */
    default net.mintern.functions.unary.checked.FloatToShortE<E> bind(int i) {
        return IntFloatToShortE.bind(this, i);
    }

    /**
     * Binds {@code (fl)} to the end of {@code f}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param fl argument 2
     * @return a new function {@code (int i) -> short} that calls
     *      {@code f.call(i, fl)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.IntToShortE<E>
    rbind(IntFloatToShortE<E> f, float fl) {
        return (i) -> f.call(i, fl);
    }

    /**
     * Binds {@code (fl)} to the end of {@code this}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param fl argument 2
     * @return a new function {@code (int i) -> short} that calls
     *      {@code this.call(i, fl)} and returns the result.
     */
    default net.mintern.functions.unary.checked.IntToShortE<E> rbind(float fl) {
        return IntFloatToShortE.rbind(this, fl);
    }

    /**
     * Binds {@code (i, fl)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param i argument 1
     * @param fl argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(i, fl)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(IntFloatToShortE<E> f, int i, float fl) {
        return () -> f.call(i, fl);
    }

    /**
     * Binds {@code (i, fl)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param i argument 1
     * @param fl argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(i, fl)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(int i, float fl) {
        return IntFloatToShortE.bind(this, i, fl);
    }
}
