package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (int, U) -> short}.
 *
 * @param <U> the type of argument 2
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface IntObjToShortE<U, E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param i argument 1
     * @param u argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(int i, U u) throws E;

    /**
     * Binds {@code (i)} to the beginning of {@code f}, returning a new function
     * of type {@code (U) -> short}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param i argument 1
     * @return a new function {@code (U u) -> short} that calls
     *      {@code f.call(i, u)} and returns the result.
     */
    static <U, E extends Exception> net.mintern.functions.unary.checked.ObjToShortE<U, E>
    bind(IntObjToShortE<U, E> f, int i) {
        return (u) -> f.call(i, u);
    }

    /**
     * Binds {@code (i)} to the beginning of {@code this}, returning a new function
     * of type {@code (U) -> short}.
     *
     * @param i argument 1
     * @return a new function {@code (U u) -> short} that calls
     *      {@code this.call(i, u)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ObjToShortE<U, E> bind(int i) {
        return IntObjToShortE.bind(this, i);
    }

    /**
     * Binds {@code (u)} to the end of {@code f}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param u argument 2
     * @return a new function {@code (int i) -> short} that calls
     *      {@code f.call(i, u)} and returns the result.
     */
    static <U, E extends Exception> net.mintern.functions.unary.checked.IntToShortE<E>
    rbind(IntObjToShortE<U, E> f, U u) {
        return (i) -> f.call(i, u);
    }

    /**
     * Binds {@code (u)} to the end of {@code this}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param u argument 2
     * @return a new function {@code (int i) -> short} that calls
     *      {@code this.call(i, u)} and returns the result.
     */
    default net.mintern.functions.unary.checked.IntToShortE<E> rbind(U u) {
        return IntObjToShortE.rbind(this, u);
    }

    /**
     * Binds {@code (i, u)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <U> the type of argument 2
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param i argument 1
     * @param u argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(i, u)} and returns the result.
     */
    static <U, E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(IntObjToShortE<U, E> f, int i, U u) {
        return () -> f.call(i, u);
    }

    /**
     * Binds {@code (i, u)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param i argument 1
     * @param u argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(i, u)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(int i, U u) {
        return IntObjToShortE.bind(this, i, u);
    }
}
