package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (int, short) -> byte}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface IntShortToByteE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param i argument 1
     * @param sh argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    byte call(int i, short sh) throws E;

    /**
     * Binds {@code (i)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> byte}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param i argument 1
     * @return a new function {@code (short sh) -> byte} that calls
     *      {@code f.call(i, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToByteE<E>
    bind(IntShortToByteE<E> f, int i) {
        return (sh) -> f.call(i, sh);
    }

    /**
     * Binds {@code (i)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> byte}.
     *
     * @param i argument 1
     * @return a new function {@code (short sh) -> byte} that calls
     *      {@code this.call(i, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToByteE<E> bind(int i) {
        return IntShortToByteE.bind(this, i);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (int) -> byte}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (int i) -> byte} that calls
     *      {@code f.call(i, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.IntToByteE<E>
    rbind(IntShortToByteE<E> f, short sh) {
        return (i) -> f.call(i, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (int) -> byte}.
     *
     * @param sh argument 2
     * @return a new function {@code (int i) -> byte} that calls
     *      {@code this.call(i, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.IntToByteE<E> rbind(short sh) {
        return IntShortToByteE.rbind(this, sh);
    }

    /**
     * Binds {@code (i, sh)} to {@code f}, returning a new function
     * of type {@code () -> byte}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param i argument 1
     * @param sh argument 2
     * @return a new function {@code () -> byte} that calls
     *      {@code f.call(i, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToByteE<E>
    bind(IntShortToByteE<E> f, int i, short sh) {
        return () -> f.call(i, sh);
    }

    /**
     * Binds {@code (i, sh)} to {@code this}, returning a new function
     * of type {@code () -> byte}.
     *
     * @param i argument 1
     * @param sh argument 2
     * @return a new function {@code () -> byte} that calls
     *      {@code this.call(i, sh)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToByteE<E> bind(int i, short sh) {
        return IntShortToByteE.bind(this, i, sh);
    }
}
