package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (int, short) -> int}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface IntShortToIntE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param i argument 1
     * @param sh argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    int call(int i, short sh) throws E;

    /**
     * Binds {@code (i)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> int}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param i argument 1
     * @return a new function {@code (short sh) -> int} that calls
     *      {@code f.call(i, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToIntE<E>
    bind(IntShortToIntE<E> f, int i) {
        return (sh) -> f.call(i, sh);
    }

    /**
     * Binds {@code (i)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> int}.
     *
     * @param i argument 1
     * @return a new function {@code (short sh) -> int} that calls
     *      {@code this.call(i, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToIntE<E> bind(int i) {
        return IntShortToIntE.bind(this, i);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (int) -> int}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (int i) -> int} that calls
     *      {@code f.call(i, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.IntToIntE<E>
    rbind(IntShortToIntE<E> f, short sh) {
        return (i) -> f.call(i, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (int) -> int}.
     *
     * @param sh argument 2
     * @return a new function {@code (int i) -> int} that calls
     *      {@code this.call(i, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.IntToIntE<E> rbind(short sh) {
        return IntShortToIntE.rbind(this, sh);
    }

    /**
     * Binds {@code (i, sh)} to {@code f}, returning a new function
     * of type {@code () -> int}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param i argument 1
     * @param sh argument 2
     * @return a new function {@code () -> int} that calls
     *      {@code f.call(i, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToIntE<E>
    bind(IntShortToIntE<E> f, int i, short sh) {
        return () -> f.call(i, sh);
    }

    /**
     * Binds {@code (i, sh)} to {@code this}, returning a new function
     * of type {@code () -> int}.
     *
     * @param i argument 1
     * @param sh argument 2
     * @return a new function {@code () -> int} that calls
     *      {@code this.call(i, sh)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToIntE<E> bind(int i, short sh) {
        return IntShortToIntE.bind(this, i, sh);
    }
}
