package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (int, short) -> void}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface IntShortToNilE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param i argument 1
     * @param sh argument 2
     * @throws E if the operation cannot be completed
     */
    void call(int i, short sh) throws E;

    /**
     * Binds {@code (i)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> void}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param i argument 1
     * @return a new function {@code (short sh) -> void} that calls
     *      {@code f.call(i, sh)}.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToNilE<E>
    bind(IntShortToNilE<E> f, int i) {
        return (sh) -> f.call(i, sh);
    }

    /**
     * Binds {@code (i)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> void}.
     *
     * @param i argument 1
     * @return a new function {@code (short sh) -> void} that calls
     *      {@code this.call(i, sh)}.
     */
    default net.mintern.functions.unary.checked.ShortToNilE<E> bind(int i) {
        return IntShortToNilE.bind(this, i);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (int) -> void}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (int i) -> void} that calls
     *      {@code f.call(i, sh)}.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.IntToNilE<E>
    rbind(IntShortToNilE<E> f, short sh) {
        return (i) -> f.call(i, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (int) -> void}.
     *
     * @param sh argument 2
     * @return a new function {@code (int i) -> void} that calls
     *      {@code this.call(i, sh)}.
     */
    default net.mintern.functions.unary.checked.IntToNilE<E> rbind(short sh) {
        return IntShortToNilE.rbind(this, sh);
    }

    /**
     * Binds {@code (i, sh)} to {@code f}, returning a new function
     * of type {@code () -> void}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param i argument 1
     * @param sh argument 2
     * @return a new function {@code () -> void} that calls
     *      {@code f.call(i, sh)}.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToNilE<E>
    bind(IntShortToNilE<E> f, int i, short sh) {
        return () -> f.call(i, sh);
    }

    /**
     * Binds {@code (i, sh)} to {@code this}, returning a new function
     * of type {@code () -> void}.
     *
     * @param i argument 1
     * @param sh argument 2
     * @return a new function {@code () -> void} that calls
     *      {@code this.call(i, sh)}.
     */
    default net.mintern.functions.nullary.checked.NilToNilE<E> bind(int i, short sh) {
        return IntShortToNilE.bind(this, i, sh);
    }
}
