package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (long, boolean) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface LongBoolToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param l argument 1
     * @param bool argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(long l, boolean bool) throws E;

    /**
     * Binds {@code (l)} to the beginning of {@code f}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l argument 1
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code f.call(l, bool)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.BoolToShortE<E>
    bind(LongBoolToShortE<E> f, long l) {
        return (bool) -> f.call(l, bool);
    }

    /**
     * Binds {@code (l)} to the beginning of {@code this}, returning a new function
     * of type {@code (boolean) -> short}.
     *
     * @param l argument 1
     * @return a new function {@code (boolean bool) -> short} that calls
     *      {@code this.call(l, bool)} and returns the result.
     */
    default net.mintern.functions.unary.checked.BoolToShortE<E> bind(long l) {
        return LongBoolToShortE.bind(this, l);
    }

    /**
     * Binds {@code (bool)} to the end of {@code f}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param bool argument 2
     * @return a new function {@code (long l) -> short} that calls
     *      {@code f.call(l, bool)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.LongToShortE<E>
    rbind(LongBoolToShortE<E> f, boolean bool) {
        return (l) -> f.call(l, bool);
    }

    /**
     * Binds {@code (bool)} to the end of {@code this}, returning a new function
     * of type {@code (long) -> short}.
     *
     * @param bool argument 2
     * @return a new function {@code (long l) -> short} that calls
     *      {@code this.call(l, bool)} and returns the result.
     */
    default net.mintern.functions.unary.checked.LongToShortE<E> rbind(boolean bool) {
        return LongBoolToShortE.rbind(this, bool);
    }

    /**
     * Binds {@code (l, bool)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l argument 1
     * @param bool argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(l, bool)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(LongBoolToShortE<E> f, long l, boolean bool) {
        return () -> f.call(l, bool);
    }

    /**
     * Binds {@code (l, bool)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param l argument 1
     * @param bool argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(l, bool)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(long l, boolean bool) {
        return LongBoolToShortE.bind(this, l, bool);
    }
}
