package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (long, short) -> long}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface LongShortToLongE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param l argument 1
     * @param sh argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    long call(long l, short sh) throws E;

    /**
     * Binds {@code (l)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> long}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l argument 1
     * @return a new function {@code (short sh) -> long} that calls
     *      {@code f.call(l, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToLongE<E>
    bind(LongShortToLongE<E> f, long l) {
        return (sh) -> f.call(l, sh);
    }

    /**
     * Binds {@code (l)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> long}.
     *
     * @param l argument 1
     * @return a new function {@code (short sh) -> long} that calls
     *      {@code this.call(l, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToLongE<E> bind(long l) {
        return LongShortToLongE.bind(this, l);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (long) -> long}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (long l) -> long} that calls
     *      {@code f.call(l, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.LongToLongE<E>
    rbind(LongShortToLongE<E> f, short sh) {
        return (l) -> f.call(l, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (long) -> long}.
     *
     * @param sh argument 2
     * @return a new function {@code (long l) -> long} that calls
     *      {@code this.call(l, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.LongToLongE<E> rbind(short sh) {
        return LongShortToLongE.rbind(this, sh);
    }

    /**
     * Binds {@code (l, sh)} to {@code f}, returning a new function
     * of type {@code () -> long}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l argument 1
     * @param sh argument 2
     * @return a new function {@code () -> long} that calls
     *      {@code f.call(l, sh)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToLongE<E>
    bind(LongShortToLongE<E> f, long l, short sh) {
        return () -> f.call(l, sh);
    }

    /**
     * Binds {@code (l, sh)} to {@code this}, returning a new function
     * of type {@code () -> long}.
     *
     * @param l argument 1
     * @param sh argument 2
     * @return a new function {@code () -> long} that calls
     *      {@code this.call(l, sh)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToLongE<E> bind(long l, short sh) {
        return LongShortToLongE.bind(this, l, sh);
    }
}
