package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (long, short) -> void}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface LongShortToNilE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param l argument 1
     * @param sh argument 2
     * @throws E if the operation cannot be completed
     */
    void call(long l, short sh) throws E;

    /**
     * Binds {@code (l)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> void}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l argument 1
     * @return a new function {@code (short sh) -> void} that calls
     *      {@code f.call(l, sh)}.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToNilE<E>
    bind(LongShortToNilE<E> f, long l) {
        return (sh) -> f.call(l, sh);
    }

    /**
     * Binds {@code (l)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> void}.
     *
     * @param l argument 1
     * @return a new function {@code (short sh) -> void} that calls
     *      {@code this.call(l, sh)}.
     */
    default net.mintern.functions.unary.checked.ShortToNilE<E> bind(long l) {
        return LongShortToNilE.bind(this, l);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (long) -> void}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (long l) -> void} that calls
     *      {@code f.call(l, sh)}.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.LongToNilE<E>
    rbind(LongShortToNilE<E> f, short sh) {
        return (l) -> f.call(l, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (long) -> void}.
     *
     * @param sh argument 2
     * @return a new function {@code (long l) -> void} that calls
     *      {@code this.call(l, sh)}.
     */
    default net.mintern.functions.unary.checked.LongToNilE<E> rbind(short sh) {
        return LongShortToNilE.rbind(this, sh);
    }

    /**
     * Binds {@code (l, sh)} to {@code f}, returning a new function
     * of type {@code () -> void}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param l argument 1
     * @param sh argument 2
     * @return a new function {@code () -> void} that calls
     *      {@code f.call(l, sh)}.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToNilE<E>
    bind(LongShortToNilE<E> f, long l, short sh) {
        return () -> f.call(l, sh);
    }

    /**
     * Binds {@code (l, sh)} to {@code this}, returning a new function
     * of type {@code () -> void}.
     *
     * @param l argument 1
     * @param sh argument 2
     * @return a new function {@code () -> void} that calls
     *      {@code this.call(l, sh)}.
     */
    default net.mintern.functions.nullary.checked.NilToNilE<E> bind(long l, short sh) {
        return LongShortToNilE.bind(this, l, sh);
    }
}
