package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (T, char) -> short}.
 *
 * @param <T> the type of argument 1
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ObjCharToShortE<T, E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param t argument 1
     * @param ch argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(T t, char ch) throws E;

    /**
     * Binds {@code (t)} to the beginning of {@code f}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param t argument 1
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code f.call(t, ch)} and returns the result.
     */
    static <T, E extends Exception> net.mintern.functions.unary.checked.CharToShortE<E>
    bind(ObjCharToShortE<T, E> f, T t) {
        return (ch) -> f.call(t, ch);
    }

    /**
     * Binds {@code (t)} to the beginning of {@code this}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param t argument 1
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code this.call(t, ch)} and returns the result.
     */
    default net.mintern.functions.unary.checked.CharToShortE<E> bind(T t) {
        return ObjCharToShortE.bind(this, t);
    }

    /**
     * Binds {@code (ch)} to the end of {@code f}, returning a new function
     * of type {@code (T) -> short}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param ch argument 2
     * @return a new function {@code (T t) -> short} that calls
     *      {@code f.call(t, ch)} and returns the result.
     */
    static <T, E extends Exception> net.mintern.functions.unary.checked.ObjToShortE<T, E>
    rbind(ObjCharToShortE<T, E> f, char ch) {
        return (t) -> f.call(t, ch);
    }

    /**
     * Binds {@code (ch)} to the end of {@code this}, returning a new function
     * of type {@code (T) -> short}.
     *
     * @param ch argument 2
     * @return a new function {@code (T t) -> short} that calls
     *      {@code this.call(t, ch)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ObjToShortE<T, E> rbind(char ch) {
        return ObjCharToShortE.rbind(this, ch);
    }

    /**
     * Binds {@code (t, ch)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param t argument 1
     * @param ch argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(t, ch)} and returns the result.
     */
    static <T, E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(ObjCharToShortE<T, E> f, T t, char ch) {
        return () -> f.call(t, ch);
    }

    /**
     * Binds {@code (t, ch)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param t argument 1
     * @param ch argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(t, ch)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(T t, char ch) {
        return ObjCharToShortE.bind(this, t, ch);
    }
}
