package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (T, int) -> short}.
 *
 * @param <T> the type of argument 1
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ObjIntToShortE<T, E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param t argument 1
     * @param i argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(T t, int i) throws E;

    /**
     * Binds {@code (t)} to the beginning of {@code f}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param t argument 1
     * @return a new function {@code (int i) -> short} that calls
     *      {@code f.call(t, i)} and returns the result.
     */
    static <T, E extends Exception> net.mintern.functions.unary.checked.IntToShortE<E>
    bind(ObjIntToShortE<T, E> f, T t) {
        return (i) -> f.call(t, i);
    }

    /**
     * Binds {@code (t)} to the beginning of {@code this}, returning a new function
     * of type {@code (int) -> short}.
     *
     * @param t argument 1
     * @return a new function {@code (int i) -> short} that calls
     *      {@code this.call(t, i)} and returns the result.
     */
    default net.mintern.functions.unary.checked.IntToShortE<E> bind(T t) {
        return ObjIntToShortE.bind(this, t);
    }

    /**
     * Binds {@code (i)} to the end of {@code f}, returning a new function
     * of type {@code (T) -> short}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param i argument 2
     * @return a new function {@code (T t) -> short} that calls
     *      {@code f.call(t, i)} and returns the result.
     */
    static <T, E extends Exception> net.mintern.functions.unary.checked.ObjToShortE<T, E>
    rbind(ObjIntToShortE<T, E> f, int i) {
        return (t) -> f.call(t, i);
    }

    /**
     * Binds {@code (i)} to the end of {@code this}, returning a new function
     * of type {@code (T) -> short}.
     *
     * @param i argument 2
     * @return a new function {@code (T t) -> short} that calls
     *      {@code this.call(t, i)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ObjToShortE<T, E> rbind(int i) {
        return ObjIntToShortE.rbind(this, i);
    }

    /**
     * Binds {@code (t, i)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param t argument 1
     * @param i argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(t, i)} and returns the result.
     */
    static <T, E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(ObjIntToShortE<T, E> f, T t, int i) {
        return () -> f.call(t, i);
    }

    /**
     * Binds {@code (t, i)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param t argument 1
     * @param i argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(t, i)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(T t, int i) {
        return ObjIntToShortE.bind(this, t, i);
    }
}
