package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (T, short) -> float}.
 *
 * @param <T> the type of argument 1
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ObjShortToFloatE<T, E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param t argument 1
     * @param sh argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    float call(T t, short sh) throws E;

    /**
     * Binds {@code (t)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> float}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param t argument 1
     * @return a new function {@code (short sh) -> float} that calls
     *      {@code f.call(t, sh)} and returns the result.
     */
    static <T, E extends Exception> net.mintern.functions.unary.checked.ShortToFloatE<E>
    bind(ObjShortToFloatE<T, E> f, T t) {
        return (sh) -> f.call(t, sh);
    }

    /**
     * Binds {@code (t)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> float}.
     *
     * @param t argument 1
     * @return a new function {@code (short sh) -> float} that calls
     *      {@code this.call(t, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToFloatE<E> bind(T t) {
        return ObjShortToFloatE.bind(this, t);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (T) -> float}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (T t) -> float} that calls
     *      {@code f.call(t, sh)} and returns the result.
     */
    static <T, E extends Exception> net.mintern.functions.unary.checked.ObjToFloatE<T, E>
    rbind(ObjShortToFloatE<T, E> f, short sh) {
        return (t) -> f.call(t, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (T) -> float}.
     *
     * @param sh argument 2
     * @return a new function {@code (T t) -> float} that calls
     *      {@code this.call(t, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ObjToFloatE<T, E> rbind(short sh) {
        return ObjShortToFloatE.rbind(this, sh);
    }

    /**
     * Binds {@code (t, sh)} to {@code f}, returning a new function
     * of type {@code () -> float}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param t argument 1
     * @param sh argument 2
     * @return a new function {@code () -> float} that calls
     *      {@code f.call(t, sh)} and returns the result.
     */
    static <T, E extends Exception> net.mintern.functions.nullary.checked.NilToFloatE<E>
    bind(ObjShortToFloatE<T, E> f, T t, short sh) {
        return () -> f.call(t, sh);
    }

    /**
     * Binds {@code (t, sh)} to {@code this}, returning a new function
     * of type {@code () -> float}.
     *
     * @param t argument 1
     * @param sh argument 2
     * @return a new function {@code () -> float} that calls
     *      {@code this.call(t, sh)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToFloatE<E> bind(T t, short sh) {
        return ObjShortToFloatE.bind(this, t, sh);
    }
}
