package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (T, short) -> void}.
 *
 * @param <T> the type of argument 1
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ObjShortToNilE<T, E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param t argument 1
     * @param sh argument 2
     * @throws E if the operation cannot be completed
     */
    void call(T t, short sh) throws E;

    /**
     * Binds {@code (t)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> void}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param t argument 1
     * @return a new function {@code (short sh) -> void} that calls
     *      {@code f.call(t, sh)}.
     */
    static <T, E extends Exception> net.mintern.functions.unary.checked.ShortToNilE<E>
    bind(ObjShortToNilE<T, E> f, T t) {
        return (sh) -> f.call(t, sh);
    }

    /**
     * Binds {@code (t)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> void}.
     *
     * @param t argument 1
     * @return a new function {@code (short sh) -> void} that calls
     *      {@code this.call(t, sh)}.
     */
    default net.mintern.functions.unary.checked.ShortToNilE<E> bind(T t) {
        return ObjShortToNilE.bind(this, t);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (T) -> void}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (T t) -> void} that calls
     *      {@code f.call(t, sh)}.
     */
    static <T, E extends Exception> net.mintern.functions.unary.checked.ObjToNilE<T, E>
    rbind(ObjShortToNilE<T, E> f, short sh) {
        return (t) -> f.call(t, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (T) -> void}.
     *
     * @param sh argument 2
     * @return a new function {@code (T t) -> void} that calls
     *      {@code this.call(t, sh)}.
     */
    default net.mintern.functions.unary.checked.ObjToNilE<T, E> rbind(short sh) {
        return ObjShortToNilE.rbind(this, sh);
    }

    /**
     * Binds {@code (t, sh)} to {@code f}, returning a new function
     * of type {@code () -> void}.
     *
     * @param <T> the type of argument 1
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param t argument 1
     * @param sh argument 2
     * @return a new function {@code () -> void} that calls
     *      {@code f.call(t, sh)}.
     */
    static <T, E extends Exception> net.mintern.functions.nullary.checked.NilToNilE<E>
    bind(ObjShortToNilE<T, E> f, T t, short sh) {
        return () -> f.call(t, sh);
    }

    /**
     * Binds {@code (t, sh)} to {@code this}, returning a new function
     * of type {@code () -> void}.
     *
     * @param t argument 1
     * @param sh argument 2
     * @return a new function {@code () -> void} that calls
     *      {@code this.call(t, sh)}.
     */
    default net.mintern.functions.nullary.checked.NilToNilE<E> bind(T t, short sh) {
        return ObjShortToNilE.bind(this, t, sh);
    }
}
