package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (T, short) -> R}.
 *
 * @param <T> the type of argument 1
 * @param <R> the type of the return value
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ObjShortToObjE<T, R, E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param t argument 1
     * @param sh argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    R call(T t, short sh) throws E;

    /**
     * Binds {@code (t)} to the beginning of {@code f}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param <T> the type of argument 1
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param t argument 1
     * @return a new function {@code (short sh) -> R} that calls
     *      {@code f.call(t, sh)} and returns the result.
     */
    static <T, R, E extends Exception> net.mintern.functions.unary.checked.ShortToObjE<R, E>
    bind(ObjShortToObjE<T, R, E> f, T t) {
        return (sh) -> f.call(t, sh);
    }

    /**
     * Binds {@code (t)} to the beginning of {@code this}, returning a new function
     * of type {@code (short) -> R}.
     *
     * @param t argument 1
     * @return a new function {@code (short sh) -> R} that calls
     *      {@code this.call(t, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToObjE<R, E> bind(T t) {
        return ObjShortToObjE.bind(this, t);
    }

    /**
     * Binds {@code (sh)} to the end of {@code f}, returning a new function
     * of type {@code (T) -> R}.
     *
     * @param <T> the type of argument 1
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 2
     * @return a new function {@code (T t) -> R} that calls
     *      {@code f.call(t, sh)} and returns the result.
     */
    static <T, R, E extends Exception> net.mintern.functions.unary.checked.ObjToObjE<T, R, E>
    rbind(ObjShortToObjE<T, R, E> f, short sh) {
        return (t) -> f.call(t, sh);
    }

    /**
     * Binds {@code (sh)} to the end of {@code this}, returning a new function
     * of type {@code (T) -> R}.
     *
     * @param sh argument 2
     * @return a new function {@code (T t) -> R} that calls
     *      {@code this.call(t, sh)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ObjToObjE<T, R, E> rbind(short sh) {
        return ObjShortToObjE.rbind(this, sh);
    }

    /**
     * Binds {@code (t, sh)} to {@code f}, returning a new function
     * of type {@code () -> R}.
     *
     * @param <T> the type of argument 1
     * @param <R> the type of the return value
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param t argument 1
     * @param sh argument 2
     * @return a new function {@code () -> R} that calls
     *      {@code f.call(t, sh)} and returns the result.
     */
    @SuppressWarnings("unchecked") // maven spuriously warns about a type error in this case
    static <T, R, E extends Exception> net.mintern.functions.nullary.checked.NilToObjE<R, E>
    bind(ObjShortToObjE<T, R, E> f, T t, short sh) {
        return () -> f.call(t, sh);
    }

    /**
     * Binds {@code (t, sh)} to {@code this}, returning a new function
     * of type {@code () -> R}.
     *
     * @param t argument 1
     * @param sh argument 2
     * @return a new function {@code () -> R} that calls
     *      {@code this.call(t, sh)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToObjE<R, E> bind(T t, short sh) {
        return ObjShortToObjE.bind(this, t, sh);
    }
}
