package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, boolean) -> char}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortBoolToCharE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh argument 1
     * @param bool argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    char call(short sh, boolean bool) throws E;

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (boolean) -> char}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (boolean bool) -> char} that calls
     *      {@code f.call(sh, bool)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.BoolToCharE<E>
    bind(ShortBoolToCharE<E> f, short sh) {
        return (bool) -> f.call(sh, bool);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (boolean) -> char}.
     *
     * @param sh argument 1
     * @return a new function {@code (boolean bool) -> char} that calls
     *      {@code this.call(sh, bool)} and returns the result.
     */
    default net.mintern.functions.unary.checked.BoolToCharE<E> bind(short sh) {
        return ShortBoolToCharE.bind(this, sh);
    }

    /**
     * Binds {@code (bool)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> char}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param bool argument 2
     * @return a new function {@code (short sh) -> char} that calls
     *      {@code f.call(sh, bool)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToCharE<E>
    rbind(ShortBoolToCharE<E> f, boolean bool) {
        return (sh) -> f.call(sh, bool);
    }

    /**
     * Binds {@code (bool)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> char}.
     *
     * @param bool argument 2
     * @return a new function {@code (short sh) -> char} that calls
     *      {@code this.call(sh, bool)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToCharE<E> rbind(boolean bool) {
        return ShortBoolToCharE.rbind(this, bool);
    }

    /**
     * Binds {@code (sh, bool)} to {@code f}, returning a new function
     * of type {@code () -> char}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @param bool argument 2
     * @return a new function {@code () -> char} that calls
     *      {@code f.call(sh, bool)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToCharE<E>
    bind(ShortBoolToCharE<E> f, short sh, boolean bool) {
        return () -> f.call(sh, bool);
    }

    /**
     * Binds {@code (sh, bool)} to {@code this}, returning a new function
     * of type {@code () -> char}.
     *
     * @param sh argument 1
     * @param bool argument 2
     * @return a new function {@code () -> char} that calls
     *      {@code this.call(sh, bool)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToCharE<E> bind(short sh, boolean bool) {
        return ShortBoolToCharE.bind(this, sh, bool);
    }
}
