package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, boolean) -> long}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortBoolToLongE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh argument 1
     * @param bool argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    long call(short sh, boolean bool) throws E;

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (boolean) -> long}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (boolean bool) -> long} that calls
     *      {@code f.call(sh, bool)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.BoolToLongE<E>
    bind(ShortBoolToLongE<E> f, short sh) {
        return (bool) -> f.call(sh, bool);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (boolean) -> long}.
     *
     * @param sh argument 1
     * @return a new function {@code (boolean bool) -> long} that calls
     *      {@code this.call(sh, bool)} and returns the result.
     */
    default net.mintern.functions.unary.checked.BoolToLongE<E> bind(short sh) {
        return ShortBoolToLongE.bind(this, sh);
    }

    /**
     * Binds {@code (bool)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> long}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param bool argument 2
     * @return a new function {@code (short sh) -> long} that calls
     *      {@code f.call(sh, bool)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToLongE<E>
    rbind(ShortBoolToLongE<E> f, boolean bool) {
        return (sh) -> f.call(sh, bool);
    }

    /**
     * Binds {@code (bool)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> long}.
     *
     * @param bool argument 2
     * @return a new function {@code (short sh) -> long} that calls
     *      {@code this.call(sh, bool)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToLongE<E> rbind(boolean bool) {
        return ShortBoolToLongE.rbind(this, bool);
    }

    /**
     * Binds {@code (sh, bool)} to {@code f}, returning a new function
     * of type {@code () -> long}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @param bool argument 2
     * @return a new function {@code () -> long} that calls
     *      {@code f.call(sh, bool)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToLongE<E>
    bind(ShortBoolToLongE<E> f, short sh, boolean bool) {
        return () -> f.call(sh, bool);
    }

    /**
     * Binds {@code (sh, bool)} to {@code this}, returning a new function
     * of type {@code () -> long}.
     *
     * @param sh argument 1
     * @param bool argument 2
     * @return a new function {@code () -> long} that calls
     *      {@code this.call(sh, bool)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToLongE<E> bind(short sh, boolean bool) {
        return ShortBoolToLongE.bind(this, sh, bool);
    }
}
