package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, byte) -> byte}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortByteToByteE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh argument 1
     * @param b argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    byte call(short sh, byte b) throws E;

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (byte) -> byte}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (byte b) -> byte} that calls
     *      {@code f.call(sh, b)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ByteToByteE<E>
    bind(ShortByteToByteE<E> f, short sh) {
        return (b) -> f.call(sh, b);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (byte) -> byte}.
     *
     * @param sh argument 1
     * @return a new function {@code (byte b) -> byte} that calls
     *      {@code this.call(sh, b)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ByteToByteE<E> bind(short sh) {
        return ShortByteToByteE.bind(this, sh);
    }

    /**
     * Binds {@code (b)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> byte}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param b argument 2
     * @return a new function {@code (short sh) -> byte} that calls
     *      {@code f.call(sh, b)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToByteE<E>
    rbind(ShortByteToByteE<E> f, byte b) {
        return (sh) -> f.call(sh, b);
    }

    /**
     * Binds {@code (b)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> byte}.
     *
     * @param b argument 2
     * @return a new function {@code (short sh) -> byte} that calls
     *      {@code this.call(sh, b)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToByteE<E> rbind(byte b) {
        return ShortByteToByteE.rbind(this, b);
    }

    /**
     * Binds {@code (sh, b)} to {@code f}, returning a new function
     * of type {@code () -> byte}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @param b argument 2
     * @return a new function {@code () -> byte} that calls
     *      {@code f.call(sh, b)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToByteE<E>
    bind(ShortByteToByteE<E> f, short sh, byte b) {
        return () -> f.call(sh, b);
    }

    /**
     * Binds {@code (sh, b)} to {@code this}, returning a new function
     * of type {@code () -> byte}.
     *
     * @param sh argument 1
     * @param b argument 2
     * @return a new function {@code () -> byte} that calls
     *      {@code this.call(sh, b)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToByteE<E> bind(short sh, byte b) {
        return ShortByteToByteE.bind(this, sh, b);
    }
}
