package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, byte) -> double}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortByteToDblE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh argument 1
     * @param b argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    double call(short sh, byte b) throws E;

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (byte) -> double}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (byte b) -> double} that calls
     *      {@code f.call(sh, b)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ByteToDblE<E>
    bind(ShortByteToDblE<E> f, short sh) {
        return (b) -> f.call(sh, b);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (byte) -> double}.
     *
     * @param sh argument 1
     * @return a new function {@code (byte b) -> double} that calls
     *      {@code this.call(sh, b)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ByteToDblE<E> bind(short sh) {
        return ShortByteToDblE.bind(this, sh);
    }

    /**
     * Binds {@code (b)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> double}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param b argument 2
     * @return a new function {@code (short sh) -> double} that calls
     *      {@code f.call(sh, b)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToDblE<E>
    rbind(ShortByteToDblE<E> f, byte b) {
        return (sh) -> f.call(sh, b);
    }

    /**
     * Binds {@code (b)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> double}.
     *
     * @param b argument 2
     * @return a new function {@code (short sh) -> double} that calls
     *      {@code this.call(sh, b)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToDblE<E> rbind(byte b) {
        return ShortByteToDblE.rbind(this, b);
    }

    /**
     * Binds {@code (sh, b)} to {@code f}, returning a new function
     * of type {@code () -> double}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @param b argument 2
     * @return a new function {@code () -> double} that calls
     *      {@code f.call(sh, b)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToDblE<E>
    bind(ShortByteToDblE<E> f, short sh, byte b) {
        return () -> f.call(sh, b);
    }

    /**
     * Binds {@code (sh, b)} to {@code this}, returning a new function
     * of type {@code () -> double}.
     *
     * @param sh argument 1
     * @param b argument 2
     * @return a new function {@code () -> double} that calls
     *      {@code this.call(sh, b)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToDblE<E> bind(short sh, byte b) {
        return ShortByteToDblE.bind(this, sh, b);
    }
}
