package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, char) -> boolean}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortCharToBoolE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh argument 1
     * @param ch argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    boolean call(short sh, char ch) throws E;

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (char) -> boolean}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (char ch) -> boolean} that calls
     *      {@code f.call(sh, ch)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.CharToBoolE<E>
    bind(ShortCharToBoolE<E> f, short sh) {
        return (ch) -> f.call(sh, ch);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (char) -> boolean}.
     *
     * @param sh argument 1
     * @return a new function {@code (char ch) -> boolean} that calls
     *      {@code this.call(sh, ch)} and returns the result.
     */
    default net.mintern.functions.unary.checked.CharToBoolE<E> bind(short sh) {
        return ShortCharToBoolE.bind(this, sh);
    }

    /**
     * Binds {@code (ch)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> boolean}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param ch argument 2
     * @return a new function {@code (short sh) -> boolean} that calls
     *      {@code f.call(sh, ch)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToBoolE<E>
    rbind(ShortCharToBoolE<E> f, char ch) {
        return (sh) -> f.call(sh, ch);
    }

    /**
     * Binds {@code (ch)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> boolean}.
     *
     * @param ch argument 2
     * @return a new function {@code (short sh) -> boolean} that calls
     *      {@code this.call(sh, ch)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToBoolE<E> rbind(char ch) {
        return ShortCharToBoolE.rbind(this, ch);
    }

    /**
     * Binds {@code (sh, ch)} to {@code f}, returning a new function
     * of type {@code () -> boolean}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @param ch argument 2
     * @return a new function {@code () -> boolean} that calls
     *      {@code f.call(sh, ch)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToBoolE<E>
    bind(ShortCharToBoolE<E> f, short sh, char ch) {
        return () -> f.call(sh, ch);
    }

    /**
     * Binds {@code (sh, ch)} to {@code this}, returning a new function
     * of type {@code () -> boolean}.
     *
     * @param sh argument 1
     * @param ch argument 2
     * @return a new function {@code () -> boolean} that calls
     *      {@code this.call(sh, ch)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToBoolE<E> bind(short sh, char ch) {
        return ShortCharToBoolE.bind(this, sh, ch);
    }
}
