package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, char) -> void}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortCharToNilE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh argument 1
     * @param ch argument 2
     * @throws E if the operation cannot be completed
     */
    void call(short sh, char ch) throws E;

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (char) -> void}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (char ch) -> void} that calls
     *      {@code f.call(sh, ch)}.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.CharToNilE<E>
    bind(ShortCharToNilE<E> f, short sh) {
        return (ch) -> f.call(sh, ch);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (char) -> void}.
     *
     * @param sh argument 1
     * @return a new function {@code (char ch) -> void} that calls
     *      {@code this.call(sh, ch)}.
     */
    default net.mintern.functions.unary.checked.CharToNilE<E> bind(short sh) {
        return ShortCharToNilE.bind(this, sh);
    }

    /**
     * Binds {@code (ch)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> void}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param ch argument 2
     * @return a new function {@code (short sh) -> void} that calls
     *      {@code f.call(sh, ch)}.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToNilE<E>
    rbind(ShortCharToNilE<E> f, char ch) {
        return (sh) -> f.call(sh, ch);
    }

    /**
     * Binds {@code (ch)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> void}.
     *
     * @param ch argument 2
     * @return a new function {@code (short sh) -> void} that calls
     *      {@code this.call(sh, ch)}.
     */
    default net.mintern.functions.unary.checked.ShortToNilE<E> rbind(char ch) {
        return ShortCharToNilE.rbind(this, ch);
    }

    /**
     * Binds {@code (sh, ch)} to {@code f}, returning a new function
     * of type {@code () -> void}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @param ch argument 2
     * @return a new function {@code () -> void} that calls
     *      {@code f.call(sh, ch)}.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToNilE<E>
    bind(ShortCharToNilE<E> f, short sh, char ch) {
        return () -> f.call(sh, ch);
    }

    /**
     * Binds {@code (sh, ch)} to {@code this}, returning a new function
     * of type {@code () -> void}.
     *
     * @param sh argument 1
     * @param ch argument 2
     * @return a new function {@code () -> void} that calls
     *      {@code this.call(sh, ch)}.
     */
    default net.mintern.functions.nullary.checked.NilToNilE<E> bind(short sh, char ch) {
        return ShortCharToNilE.bind(this, sh, ch);
    }
}
