package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, char) -> short}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortCharToShortE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh argument 1
     * @param ch argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    short call(short sh, char ch) throws E;

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code f.call(sh, ch)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.CharToShortE<E>
    bind(ShortCharToShortE<E> f, short sh) {
        return (ch) -> f.call(sh, ch);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (char) -> short}.
     *
     * @param sh argument 1
     * @return a new function {@code (char ch) -> short} that calls
     *      {@code this.call(sh, ch)} and returns the result.
     */
    default net.mintern.functions.unary.checked.CharToShortE<E> bind(short sh) {
        return ShortCharToShortE.bind(this, sh);
    }

    /**
     * Binds {@code (ch)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param ch argument 2
     * @return a new function {@code (short sh) -> short} that calls
     *      {@code f.call(sh, ch)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToShortE<E>
    rbind(ShortCharToShortE<E> f, char ch) {
        return (sh) -> f.call(sh, ch);
    }

    /**
     * Binds {@code (ch)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> short}.
     *
     * @param ch argument 2
     * @return a new function {@code (short sh) -> short} that calls
     *      {@code this.call(sh, ch)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToShortE<E> rbind(char ch) {
        return ShortCharToShortE.rbind(this, ch);
    }

    /**
     * Binds {@code (sh, ch)} to {@code f}, returning a new function
     * of type {@code () -> short}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @param ch argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code f.call(sh, ch)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToShortE<E>
    bind(ShortCharToShortE<E> f, short sh, char ch) {
        return () -> f.call(sh, ch);
    }

    /**
     * Binds {@code (sh, ch)} to {@code this}, returning a new function
     * of type {@code () -> short}.
     *
     * @param sh argument 1
     * @param ch argument 2
     * @return a new function {@code () -> short} that calls
     *      {@code this.call(sh, ch)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToShortE<E> bind(short sh, char ch) {
        return ShortCharToShortE.bind(this, sh, ch);
    }
}
