package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, double) -> boolean}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortDblToBoolE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh argument 1
     * @param d argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    boolean call(short sh, double d) throws E;

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (double) -> boolean}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (double d) -> boolean} that calls
     *      {@code f.call(sh, d)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.DblToBoolE<E>
    bind(ShortDblToBoolE<E> f, short sh) {
        return (d) -> f.call(sh, d);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (double) -> boolean}.
     *
     * @param sh argument 1
     * @return a new function {@code (double d) -> boolean} that calls
     *      {@code this.call(sh, d)} and returns the result.
     */
    default net.mintern.functions.unary.checked.DblToBoolE<E> bind(short sh) {
        return ShortDblToBoolE.bind(this, sh);
    }

    /**
     * Binds {@code (d)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> boolean}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param d argument 2
     * @return a new function {@code (short sh) -> boolean} that calls
     *      {@code f.call(sh, d)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToBoolE<E>
    rbind(ShortDblToBoolE<E> f, double d) {
        return (sh) -> f.call(sh, d);
    }

    /**
     * Binds {@code (d)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> boolean}.
     *
     * @param d argument 2
     * @return a new function {@code (short sh) -> boolean} that calls
     *      {@code this.call(sh, d)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToBoolE<E> rbind(double d) {
        return ShortDblToBoolE.rbind(this, d);
    }

    /**
     * Binds {@code (sh, d)} to {@code f}, returning a new function
     * of type {@code () -> boolean}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @param d argument 2
     * @return a new function {@code () -> boolean} that calls
     *      {@code f.call(sh, d)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToBoolE<E>
    bind(ShortDblToBoolE<E> f, short sh, double d) {
        return () -> f.call(sh, d);
    }

    /**
     * Binds {@code (sh, d)} to {@code this}, returning a new function
     * of type {@code () -> boolean}.
     *
     * @param sh argument 1
     * @param d argument 2
     * @return a new function {@code () -> boolean} that calls
     *      {@code this.call(sh, d)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToBoolE<E> bind(short sh, double d) {
        return ShortDblToBoolE.bind(this, sh, d);
    }
}
