package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, double) -> byte}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortDblToByteE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh argument 1
     * @param d argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    byte call(short sh, double d) throws E;

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (double) -> byte}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (double d) -> byte} that calls
     *      {@code f.call(sh, d)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.DblToByteE<E>
    bind(ShortDblToByteE<E> f, short sh) {
        return (d) -> f.call(sh, d);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (double) -> byte}.
     *
     * @param sh argument 1
     * @return a new function {@code (double d) -> byte} that calls
     *      {@code this.call(sh, d)} and returns the result.
     */
    default net.mintern.functions.unary.checked.DblToByteE<E> bind(short sh) {
        return ShortDblToByteE.bind(this, sh);
    }

    /**
     * Binds {@code (d)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> byte}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param d argument 2
     * @return a new function {@code (short sh) -> byte} that calls
     *      {@code f.call(sh, d)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToByteE<E>
    rbind(ShortDblToByteE<E> f, double d) {
        return (sh) -> f.call(sh, d);
    }

    /**
     * Binds {@code (d)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> byte}.
     *
     * @param d argument 2
     * @return a new function {@code (short sh) -> byte} that calls
     *      {@code this.call(sh, d)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToByteE<E> rbind(double d) {
        return ShortDblToByteE.rbind(this, d);
    }

    /**
     * Binds {@code (sh, d)} to {@code f}, returning a new function
     * of type {@code () -> byte}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @param d argument 2
     * @return a new function {@code () -> byte} that calls
     *      {@code f.call(sh, d)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToByteE<E>
    bind(ShortDblToByteE<E> f, short sh, double d) {
        return () -> f.call(sh, d);
    }

    /**
     * Binds {@code (sh, d)} to {@code this}, returning a new function
     * of type {@code () -> byte}.
     *
     * @param sh argument 1
     * @param d argument 2
     * @return a new function {@code () -> byte} that calls
     *      {@code this.call(sh, d)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToByteE<E> bind(short sh, double d) {
        return ShortDblToByteE.bind(this, sh, d);
    }
}
