package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, double) -> float}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortDblToFloatE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh argument 1
     * @param d argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    float call(short sh, double d) throws E;

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (double) -> float}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (double d) -> float} that calls
     *      {@code f.call(sh, d)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.DblToFloatE<E>
    bind(ShortDblToFloatE<E> f, short sh) {
        return (d) -> f.call(sh, d);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (double) -> float}.
     *
     * @param sh argument 1
     * @return a new function {@code (double d) -> float} that calls
     *      {@code this.call(sh, d)} and returns the result.
     */
    default net.mintern.functions.unary.checked.DblToFloatE<E> bind(short sh) {
        return ShortDblToFloatE.bind(this, sh);
    }

    /**
     * Binds {@code (d)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> float}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param d argument 2
     * @return a new function {@code (short sh) -> float} that calls
     *      {@code f.call(sh, d)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToFloatE<E>
    rbind(ShortDblToFloatE<E> f, double d) {
        return (sh) -> f.call(sh, d);
    }

    /**
     * Binds {@code (d)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> float}.
     *
     * @param d argument 2
     * @return a new function {@code (short sh) -> float} that calls
     *      {@code this.call(sh, d)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToFloatE<E> rbind(double d) {
        return ShortDblToFloatE.rbind(this, d);
    }

    /**
     * Binds {@code (sh, d)} to {@code f}, returning a new function
     * of type {@code () -> float}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @param d argument 2
     * @return a new function {@code () -> float} that calls
     *      {@code f.call(sh, d)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToFloatE<E>
    bind(ShortDblToFloatE<E> f, short sh, double d) {
        return () -> f.call(sh, d);
    }

    /**
     * Binds {@code (sh, d)} to {@code this}, returning a new function
     * of type {@code () -> float}.
     *
     * @param sh argument 1
     * @param d argument 2
     * @return a new function {@code () -> float} that calls
     *      {@code this.call(sh, d)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToFloatE<E> bind(short sh, double d) {
        return ShortDblToFloatE.bind(this, sh, d);
    }
}
