package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, double) -> void}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortDblToNilE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh argument 1
     * @param d argument 2
     * @throws E if the operation cannot be completed
     */
    void call(short sh, double d) throws E;

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (double) -> void}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (double d) -> void} that calls
     *      {@code f.call(sh, d)}.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.DblToNilE<E>
    bind(ShortDblToNilE<E> f, short sh) {
        return (d) -> f.call(sh, d);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (double) -> void}.
     *
     * @param sh argument 1
     * @return a new function {@code (double d) -> void} that calls
     *      {@code this.call(sh, d)}.
     */
    default net.mintern.functions.unary.checked.DblToNilE<E> bind(short sh) {
        return ShortDblToNilE.bind(this, sh);
    }

    /**
     * Binds {@code (d)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> void}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param d argument 2
     * @return a new function {@code (short sh) -> void} that calls
     *      {@code f.call(sh, d)}.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToNilE<E>
    rbind(ShortDblToNilE<E> f, double d) {
        return (sh) -> f.call(sh, d);
    }

    /**
     * Binds {@code (d)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> void}.
     *
     * @param d argument 2
     * @return a new function {@code (short sh) -> void} that calls
     *      {@code this.call(sh, d)}.
     */
    default net.mintern.functions.unary.checked.ShortToNilE<E> rbind(double d) {
        return ShortDblToNilE.rbind(this, d);
    }

    /**
     * Binds {@code (sh, d)} to {@code f}, returning a new function
     * of type {@code () -> void}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @param d argument 2
     * @return a new function {@code () -> void} that calls
     *      {@code f.call(sh, d)}.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToNilE<E>
    bind(ShortDblToNilE<E> f, short sh, double d) {
        return () -> f.call(sh, d);
    }

    /**
     * Binds {@code (sh, d)} to {@code this}, returning a new function
     * of type {@code () -> void}.
     *
     * @param sh argument 1
     * @param d argument 2
     * @return a new function {@code () -> void} that calls
     *      {@code this.call(sh, d)}.
     */
    default net.mintern.functions.nullary.checked.NilToNilE<E> bind(short sh, double d) {
        return ShortDblToNilE.bind(this, sh, d);
    }
}
