package net.mintern.functions.binary.checked;

/**
 * An operation of type {@code (short, float) -> int}.
 *
 * @param <E> the {@code Exception} type that the operation may throw
 */
@FunctionalInterface
public interface ShortFloatToIntE<E extends Exception> {

    /**
     * Performs this operation.
     *
     * @param sh argument 1
     * @param fl argument 2
     * @return the result of the operation
     * @throws E if the operation cannot be completed
     */
    int call(short sh, float fl) throws E;

    /**
     * Binds {@code (sh)} to the beginning of {@code f}, returning a new function
     * of type {@code (float) -> int}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @return a new function {@code (float fl) -> int} that calls
     *      {@code f.call(sh, fl)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.FloatToIntE<E>
    bind(ShortFloatToIntE<E> f, short sh) {
        return (fl) -> f.call(sh, fl);
    }

    /**
     * Binds {@code (sh)} to the beginning of {@code this}, returning a new function
     * of type {@code (float) -> int}.
     *
     * @param sh argument 1
     * @return a new function {@code (float fl) -> int} that calls
     *      {@code this.call(sh, fl)} and returns the result.
     */
    default net.mintern.functions.unary.checked.FloatToIntE<E> bind(short sh) {
        return ShortFloatToIntE.bind(this, sh);
    }

    /**
     * Binds {@code (fl)} to the end of {@code f}, returning a new function
     * of type {@code (short) -> int}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param fl argument 2
     * @return a new function {@code (short sh) -> int} that calls
     *      {@code f.call(sh, fl)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.unary.checked.ShortToIntE<E>
    rbind(ShortFloatToIntE<E> f, float fl) {
        return (sh) -> f.call(sh, fl);
    }

    /**
     * Binds {@code (fl)} to the end of {@code this}, returning a new function
     * of type {@code (short) -> int}.
     *
     * @param fl argument 2
     * @return a new function {@code (short sh) -> int} that calls
     *      {@code this.call(sh, fl)} and returns the result.
     */
    default net.mintern.functions.unary.checked.ShortToIntE<E> rbind(float fl) {
        return ShortFloatToIntE.rbind(this, fl);
    }

    /**
     * Binds {@code (sh, fl)} to {@code f}, returning a new function
     * of type {@code () -> int}.
     *
     * @param <E> the {@code Exception} type that the operation may throw
     * @param f the unbound function
     * @param sh argument 1
     * @param fl argument 2
     * @return a new function {@code () -> int} that calls
     *      {@code f.call(sh, fl)} and returns the result.
     */
    static <E extends Exception> net.mintern.functions.nullary.checked.NilToIntE<E>
    bind(ShortFloatToIntE<E> f, short sh, float fl) {
        return () -> f.call(sh, fl);
    }

    /**
     * Binds {@code (sh, fl)} to {@code this}, returning a new function
     * of type {@code () -> int}.
     *
     * @param sh argument 1
     * @param fl argument 2
     * @return a new function {@code () -> int} that calls
     *      {@code this.call(sh, fl)} and returns the result.
     */
    default net.mintern.functions.nullary.checked.NilToIntE<E> bind(short sh, float fl) {
        return ShortFloatToIntE.bind(this, sh, fl);
    }
}
